SET TERM ^ ;

create or alter procedure pagamentosmovimento (
    codmovpdv integer,
    codformpag integer)
returns (
    idforma integer,
    idvenda integer,
    forma varchar(60),
    valor numeric(15,2),
    valorpago numeric(15,2))
as
declare variable iddinheiro integer;
declare variable vartotalvenda numeric(15,2);
declare variable troco numeric(15,2);
begin

SELECT first 1 CODFMPAG FROM formaspagam where upper(forma)='DINHEIRO' order by forma into IDDINHEIRO;

for select
FPV.codvenda,
FP.codfmpag,
fp.forma,
fpv.valor,
fpv.valortotal,
V.VALORTOTAL
from VENDA as V
INNER JOIN formaspagvenda fpv ON (FPV.codvenda=V.CODVENDA AND fpv.tipo=0)
inner join formaspagam fp on (fp.codfmpag=fpv.codformpag)
WHERE V.CODMOVPDV= :CODMOVPDV AND FPV.codformpag = :CODFORMPAG and v.tiporegistro=1
order by 1
into 
:IDVENDA,
:idforma,
:forma,
:valor,
:valorpago,
:VARTOTALVENDA
do
begin
  if (IDFORMA=iddinheiro) then
  BEGIN
       if (valor<>VARTOTALVENDA) then
       begin

               valor=:valor;
       end
       if (valor>VARTOTALVENDA) then
       begin
               select COALESCE(sum(fp.valor),0) from formaspagvenda fp
               where fp.codvenda=:IDVENDA and fp.codmovpdv=:CODMOVPDV and fp.tipo=3 AND fp.CODFORMPAG=:IDDINHEIRO into troco;

          valor=valor-:troco;
       end
  END

  suspend;
end

end^

SET TERM ; ^

/* Following GRANT statements are generated automatically */

GRANT SELECT ON FORMASPAGAM TO PROCEDURE PAGAMENTOSMOVIMENTO;
GRANT SELECT ON VENDA TO PROCEDURE PAGAMENTOSMOVIMENTO;
GRANT SELECT ON FORMASPAGVENDA TO PROCEDURE PAGAMENTOSMOVIMENTO;

/* Existing privileges on this procedure */

GRANT EXECUTE ON PROCEDURE PAGAMENTOSMOVIMENTO TO PROCEDURE FECHAMENTO_PERIODO;
GRANT EXECUTE ON PROCEDURE PAGAMENTOSMOVIMENTO TO SYSDBA;
































SET TERM ^ ;

create or alter procedure FECHAMENTO_PERIODO (
    CODMOVPDV integer)
returns (
    ABERTO_FECHADO varchar(7),
    TIPO varchar(30),
    NOME_PDV varchar(10),
    FORMAPAGAMENTO varchar(50),
    RECEBIDO numeric(18,3),
    VENDABRUTA numeric(18,3),
    CANCELAMENTOS_VALOR_TOTAL numeric(18,3),
    CANCELAMENTOS_VALOR_ITENS numeric(18,3),
    CANCELAMENTOS_VALOR_CUPONS numeric(18,3),
    CANCELAMENTOS_QUANT_TOTAL numeric(18,3),
    CANCELAMENTOS_QUANT_ITENS numeric(18,3),
    CANCELAMENTOS_QUANT_CUPONS numeric(18,3),
    DESCONTOS_VALOR_TOTAL numeric(18,3),
    DESCONTOS_VALOR_ITENS numeric(18,3),
    DESCONTOS_VALOR_CUPONS numeric(18,3),
    DESCONTOS_QUANT_TOTAL numeric(18,3),
    DESCONTOS_QUANT_ITENS numeric(18,3),
    DESCONTOS_QUANT_CUPONS numeric(18,3),
    VENDA_LIQUIDA numeric(18,3),
    ACRESCIMOS_VALOR_TOTAL numeric(18,3),
    ACRESCIMOS_VALOR_ITENS numeric(18,3),
    ACRESCIMOS_VALOR_CUPONS numeric(18,3),
    ACRESCIMOS_QUANT_TOTAL numeric(18,3),
    ACRESCIMOS_QUANT_ITENS numeric(18,3),
    ACRESCIMOS_QUANT_CUPONS numeric(18,3),
    TOTAL numeric(18,3),
    ABERTURA numeric(18,3),
    ABERTURA_DATA date,
    ABERTURA_HORA time,
    FECHAMENTO_DATA date,
    FECHAMENTO_HORA time,
    COD_OPERADOR integer,
    NOME_OPERADOR varchar(50),
    VALOR_FECHAMENTO numeric(18,3),
    CODPDV integer,
    CODSUPERVISORABERTURA integer,
    ITENSVENDIDOS numeric(18,3),
    CUPOM_MEDIO numeric(18,3),
    TOTAL_CLI_ATENDIDOS integer,
    ITEM_MEDIO numeric(18,3),
    TOTALTROCO numeric(18,3),
    ENTRANOCAIXA integer,
    IDFINALIZADORA integer)
as
declare variable VARTOTALSUPRIMENTO numeric(12,3);
declare variable VARTOTALSANGRIA numeric(12,3);
declare variable VARTOTALSANGRIADINHEIRO numeric(12,3);
declare variable VARTOTALENTRADA numeric(12,3);
declare variable VARTOTALTROCO numeric(12,3);
declare variable VARTOTALGERAL numeric(12,3);
declare variable VARABERTURAINICIAL numeric(12,3);
declare variable VAR_ABERTO_FECHADO integer;
declare variable VAR_TOTALENTRADAS numeric(12,3);
declare variable VAR_TOTALTROCO numeric(12,3);
declare variable VAR_TOTALSANGRIA numeric(12,3);
declare variable VAR_TOTALSUPRIMENTO numeric(12,3);
declare variable VARVALORTOTAL numeric(12,3);
declare variable VARTOTALDESCONTOS numeric(12,3);
declare variable VARTOTALCANCELAMENTOS numeric(12,3);
declare variable VARFINDINHEIRO numeric(12,3);
declare variable VAROUTRAS numeric(12,3);
declare variable VARSALDODINHEIRO numeric(12,3);
declare variable CODDINHEIRO integer;
declare variable COD_FORMA_PAGAMENTO integer;
declare variable DESCONTOSCUPOMCANCELADOS numeric(12,3);
declare variable CODTROCA integer;
declare variable VARTOTALTROCA numeric(15,2);
declare variable VCALCULAVENDABRUTA numeric(15,2);
declare variable VARIDPAGAMENTOCONTAS integer;
declare variable SANDRIADADA numeric(15,2);
declare variable VALORTROCO numeric(15,2);
begin

RECEBIDO=0;

/* Pega o nome do PDV*/
select P.PDVNOME from confsistema P INTO :NOME_PDV;


select FIRST 1 CODFMPAG FROM FORMASPAGAM WHERE UPPER(FORMA)='DINHEIRO' order by forma into :codDinheiro;
select FIRST 1 coalesce(CODFMPAG,0) FROM FORMASPAGAM WHERE UPPER(FORMA)='TROCA' order by forma into :codTroca;
select FIRST 1 coalesce(CODFMPAG,0) FROM FORMASPAGAM WHERE UPPER(FORMA)='RECEBIMENTO DE CONTA' order by forma into :VARIDPAGAMENTOCONTAS;



SELECT
M.CODPDV,M.ABERTURA_DATA,M.ABERTURA_HORA,M. ABERTURA_SUPRIMENTO,M.ABERTURA_OPERADOR,
M.ABERTURA_SUPERVISOR,M.FECHA_DATA,M.FECHA_HORA,
M.FECHA_VENDABRUTA,M.FECHA_VENDALIQUIDA,M.CANCEL_CUPOM_VAL,M.CANCEL_CUPOM_QTD,
M.CANCEL_ITEM_VAL,M.CANCEL_ITEM_QTD,M.FECHA_FECHADO,
M.DESCONTO_CUPOM_VAL,M.DESCONTO_CUPOM_QTD,M.DESCONTO_ITEM_VAL,M.DESCONTO_ITEM_QTD,
M.ACRESCIMO_CUPOM_VAL,M.ACRESCIMO_CUPOM_QTD,M.ACRESCIMO_ITEM_VAL,M.ACRESCIMO_ITEM_QTD,
M.FECHA_TOTALITENS,M.FECHA_TOTALTROCO,M.FECHA_TOTALVENDAS
FROM MOVPDV M WHERE M.CODMOV=:CODMOVPDV
INTO
:CODPDV,:ABERTURA_DATA,:ABERTURA_HORA,:ABERTURA,:COD_OPERADOR,
:CODSUPERVISORABERTURA,:FECHAMENTO_DATA,:FECHAMENTO_HORA,
:VENDABRUTA,:VENDA_LIQUIDA,:CANCELAMENTOS_VALOR_CUPONS,:CANCELAMENTOS_QUANT_CUPONS,
:CANCELAMENTOS_VALOR_ITENS,:CANCELAMENTOS_QUANT_ITENS,:VAR_ABERTO_FECHADO,
:DESCONTOS_VALOR_CUPONS,:DESCONTOS_QUANT_CUPONS,:DESCONTOS_VALOR_ITENS,:DESCONTOS_QUANT_ITENS,
:ACRESCIMOS_VALOR_CUPONS,:ACRESCIMOS_QUANT_CUPONS,:ACRESCIMOS_VALOR_ITENS,:ACRESCIMOS_QUANT_ITENS,
:ITENSVENDIDOS,:TOTALTROCO,:TOTAL_CLI_ATENDIDOS;
varTotalCancelamentos=:CANCELAMENTOS_VALOR_TOTAL;
CANCELAMENTOS_QUANT_TOTAL=:CANCELAMENTOS_QUANT_CUPONS+:CANCELAMENTOS_QUANT_ITENS;
DESCONTOS_VALOR_TOTAL=:DESCONTOS_VALOR_CUPONS+:DESCONTOS_VALOR_ITENS;



/* Tratamento de Descontos  */

   DESCONTOS_QUANT_TOTAL=0;

   /* Total de Cupons Descontos */
   SELECT Count(*) FROM VENDA V WHERE V.CODMOVPDV=:CODMOVPDV AND (V.TIPOREGISTRO=1) AND (V.DESCONTO_VAL > 0) into :DESCONTOS_QUANT_CUPONS;

   /* Valor de Cupons Descontos */
   SELECT COALESCE(SUM(V.DESCONTO_VAL),0) FROM VENDA V WHERE (V.CODMOVPDV=:CODMOVPDV) AND (V.TIPOREGISTRO=1) INTO :DESCONTOS_VALOR_CUPONS;

   /* Total de Itens Descontos */
   SELECT Count(*) FROM PRODVENDA PROD WHERE PROD.CODMOVPDV=:CODMOVPDV AND PROD.DESCONTOVALOR>0 INTO :DESCONTOS_QUANT_ITENS;

   /* Valor de Itens Descontos */
   SELECT COALESCE(SUM(PROD.DESCONTOVALOR),0) FROM PRODVENDA PROD
   inner join VENDA V ON (V.CODVENDA=PROD.CODVENDA AND V.TIPOREGISTRO=1)
   WHERE PROD.CODMOVPDV=:CODMOVPDV
   AND COALESCE(PROD.CANCELADO,0)=0
   AND PROD.DESCONTOVALOR>0
   INTO :DESCONTOS_VALOR_ITENS;


DESCONTOS_QUANT_TOTAL=:DESCONTOS_QUANT_CUPONS+:DESCONTOS_QUANT_ITENS;
   DESCONTOS_VALOR_TOTAL=:DESCONTOS_VALOR_CUPONS+:DESCONTOS_VALOR_ITENS;

/* Final Tratamento de Descontos */


/* Pega o total de troca             */
SELECT
COALESCE(SUM(FPG.VALORTOTAL),0) TOTAL
FROM FORMASPAGVENDA FPG
INNER JOIN VENDA V ON (V.CODVENDA=FPG.codvenda AND V.tiporegistro=1)
where
(FPG.CODMOVPDV=:CODMOVPDV
)
and FPG.CODFORMPAG=(select FIRST 1 CODFMPAG FROM FORMASPAGAM WHERE UPPER(FORMA)='TROCA' order by forma)
INTO :VARTOTALTROCA;




/* INICIO DO CALCULO DA VENDA BRUTA */
VENDABRUTA=0;

/* TOTAL DA VENDA */
select
sum(vd.valortotal)
from venda vd
WHERE vd.CODMOVPDV=:CODMOVPDV
and vd.tiporegistro=1
INTO :VENDABRUTA;

/* TOTAL DE CANCELAMENTOS DE VENDAS */
select
COALESCE(sum(vd.valortotal),0)
from venda vd
WHERE vd.CODMOVPDV=:CODMOVPDV
and vd.tiporegistro=4 into :VCALCULAVENDABRUTA;

VENDABRUTA=:VENDABRUTA+:VCALCULAVENDABRUTA;


/* TOTAL DE CANCELAMENTOS DE ITENS */
select
COALESCE(sum(PV.total),0)
from PRODVENDA PV
INNER JOIN VENDA V ON (V.codvenda=PV.codvenda AND V.codmovpdv=PV.codmovpdv AND V.codpdv=PV.codpdv AND V.tiporegistro=1)
WHERE
PV.CODMOVPDV=:CODMOVPDV
and PV.tiporegistro=4  into :VCALCULAVENDABRUTA;

VENDABRUTA=:VENDABRUTA+:VCALCULAVENDABRUTA;


/* TOTAL DE DESCONTO DE ITENS */
select
COALESCE(sum(PV.descontovalor),0)
from PRODVENDA PV
INNER JOIN VENDA V ON (V.codvenda=PV.codvenda AND V.codmovpdv=PV.codmovpdv AND V.codpdv=PV.codpdv AND V.tiporegistro=1)
WHERE
PV.CODMOVPDV=:CODMOVPDV
and PV.tiporegistro=1 into :VCALCULAVENDABRUTA;

VENDABRUTA=:VENDABRUTA+:VCALCULAVENDABRUTA;



/* TOTAL DE DESCONTO DE vendas */
select
COALESCE(sum(v.desconto_val),0)
from VENDA V
WHERE
V.CODMOVPDV=:CODMOVPDV AND
V.tiporegistro=1 and
v.desconto_val>0 into :VCALCULAVENDABRUTA;

VENDABRUTA=:VENDABRUTA+:VCALCULAVENDABRUTA;
/* Final total venda bruta */


vendabruta = :vendabruta -   :VARTOTALTROCA;

/* Tratamento de acrescimos  */

   /* Quantidade de Cupons acrescimos */
   SELECT Count(*) FROM VENDA V WHERE
   V.CODMOVPDV=:CODMOVPDV
   AND V.TIPOREGISTRO=1
   AND (ACRESCIMO_VAL > 0)
   into :ACRESCIMOS_QUANT_CUPONS;

   /* Valor de Cupons acrescios */
   SELECT COALESCE(Sum(ACRESCIMO_VAL),0) FROM VENDA V WHERE
   V.CODMOVPDV=:CODMOVPDV
   AND V.TIPOREGISTRO=1
   AND ACRESCIMO_VAL > 0
   INTO :ACRESCIMOS_VALOR_CUPONS;

   /* Quantidade de Itens ACRESCIMOS */
   SELECT Count(*) FROM PRODVENDA PROD WHERE
   PROD.CODMOVPDV=:CODMOVPDV
   AND PROD.CANCELADO<>1
   AND PROD.ACRESCIMOVALOR>0
   INTO :ACRESCIMOS_QUANT_ITENS;

   /* Valor de Itens ACRESCIMOS */
   SELECT COALESCE(SUM(PROD.ACRESCIMOVALOR),0) FROM PRODVENDA PROD
   JOIN VENDA V ON
   (V.CODVENDA=PROD.CODVENDA
   AND V.CODMOVPDV=:CODMOVPDV
   AND V.TIPOREGISTRO=1
   and PROD.CANCELADO<>1)
   WHERE
   V.CODMOVPDV=:CODMOVPDV
   INTO :ACRESCIMOS_VALOR_ITENS;

   ACRESCIMOS_QUANT_TOTAL=:ACRESCIMOS_QUANT_CUPONS+:ACRESCIMOS_QUANT_ITENS;
   ACRESCIMOS_VALOR_TOTAL=:ACRESCIMOS_VALOR_CUPONS+:ACRESCIMOS_VALOR_ITENS;

/* Final Tratamento de ACRESCIMOS */

/* Tratamento de cancelamentos  */

   /* Quantidade de Cupons Cancelados */
   SELECT Count(*) FROM VENDA V WHERE
   V.CODMOVPDV=:CODMOVPDV
   AND V.TIPOREGISTRO=4 into :CANCELAMENTOS_QUANT_CUPONS;


   /* Valor de Cupons Cancelados */
   SELECT COALESCE(SUM(V.VALORTOTAL),0)
   FROM VENDA V
   WHERE  V.CODMOVPDV=:CODMOVPDV
   AND
   V.TIPOREGISTRO=4 INTO :CANCELAMENTOS_VALOR_CUPONS;


   /* Quantidade de Itens Cancelados */
   SELECT Count(*) FROM PRODVENDA PROD
   inner join venda v on(prod.codvenda=v.codvenda)
   WHERE
   PROD.CODMOVPDV=:CODMOVPDV
   AND PROD.CANCELADO=1
   and v.tiporegistro<>4
   into :CANCELAMENTOS_QUANT_ITENS;

   /* Valor de Itens Cancelados */
   SELECT COALESCE(SUM(PROD.TOTAL),0)+
   COALESCE(SUM(PROD.descontovalor),0)
   FROM PRODVENDA PROD
   inner join venda v on(prod.codvenda=v.codvenda)
   where PROD.CANCELADO=1 AND
   PROD.CODMOVPDV=:CODMOVPDV
   and v.tiporegistro<>4
   INTO :CANCELAMENTOS_VALOR_ITENS;
   
   CANCELAMENTOS_VALOR_TOTAL=:CANCELAMENTOS_VALOR_CUPONS+:CANCELAMENTOS_VALOR_ITENS;
   CANCELAMENTOS_QUANT_TOTAL=:CANCELAMENTOS_QUANT_CUPONS+:CANCELAMENTOS_QUANT_ITENS;


/* Final Tratamento de cancelamentos */


VENDA_LIQUIDA=:VENDABRUTA  - :CANCELAMENTOS_VALOR_TOTAL + :CANCELAMENTOS_VALOR_ITENS;
VENDA_LIQUIDA=:VENDA_LIQUIDA - :DESCONTOS_VALOR_TOTAL ;


/* Total de clientes atendidos */
SELECT COALESCE(COUNT(*),0) FROM VENDA V
WHERE
V.TIPOREGISTRO=1
AND V.CODMOVPDV=:CODMOVPDV INTO :TOTAL_CLI_ATENDIDOS;


/* Total de clientes atendidos */
IF (:TOTAL_CLI_ATENDIDOS=0) THEN
BEGIN
CUPOM_MEDIO=0;
END
  ELSE
BEGIN
  CUPOM_MEDIO=:VENDA_LIQUIDA /:TOTAL_CLI_ATENDIDOS;
END


IF (:ITENSVENDIDOS=0) THEN
BEGIN
     ITEM_MEDIO=0;
END ELSE
BEGIN
     ITEM_MEDIO=:VENDA_LIQUIDA / :ITENSVENDIDOS;
END


RECEBIDO=0;

SELECT U.NOME FROM USUARIOS U WHERE (U.CODUSUARIO=:COD_OPERADOR) INTO :NOME_OPERADOR;

FORMAPAGAMENTO='Dinheiro';
TIPO='ABERTURA';
TOTAL=0;/*:ABERTURA; atribui o total a igual a zero por nao adicionar o suprimento */
if (VAR_ABERTO_FECHADO=1) THEN ABERTO_FECHADO='FECHADO'; ELSE ABERTO_FECHADO='ABERTO';
RECEBIDO=0;
varAberturaInicial=:ABERTURA;

SUSPEND;


    VENDA_LIQUIDA = 0;
    VENDABRUTA = 0;
    ABERTURA  =0;

    VAR_TOTALENTRADAS=0;
    varOutras=0;

/* pega o total em suprimentos */
SELECT
COALESCE(SUM(FPG.VALORTOTAL),0) TOTAL
FROM FORMASPAGVENDA FPG
inner join venda vd on ((vd.tiporegistro=7) and (fpg.codvenda=vd.codvenda))
where
(FPG.CODMOVPDV=:CODMOVPDV
and FPG.TIPO=1)
and FPG.CODFORMPAG=:codDinheiro into :VAR_TOTALSUPRIMENTO;



/* CALCULA O TOTAL EM TROCO */
FORMAPAGAMENTO='TROCO';
COD_FORMA_PAGAMENTO=-1;

RECEBIDO=0;
 SELECT
    COALESCE(SUM(FPV.VALOR),0)
    from FORMASPAGVENDA FPV
    INNER JOIN VENDA V on (FPV.CODVENDA=V.CODVENDA AND V.TIPOREGISTRO=1)
    WHERE FPV.TIPO=3 
    and (FPV.CODMOVPDV=:CODMOVPDV)
    and (FPV.CODPDV=:CODPDV)
    INTO :RECEBIDO;
    TOTAL=:RECEBIDO;
    TIPO='TROCO';
    VAR_TOTALTROCO=:RECEBIDO;


select
sum(fpva.valor)
from formaspagvenda fpva
where fpva.codvenda in
    (
        select
        fpv.codvenda from formaspagvenda fpv
        inner join formaspagam fp on (fp.codfmpag=fpv.codformpag and FP.forma <> 'DINHEIRO' and fpv.codmovpdv=:CODMOVPDV and fpv.CODPDV=:CODPDV)
        INNER JOIN VENDA VD ON (fpv.codvenda=vd.codvenda and vd.tiporegistro=1)
        where fpv.codmovpdv=:CODMOVPDV and fpv.CODPDV=:CODPDV and
        (
          (select count(1) from formaspagvenda fpvtroco where (fpvtroco.codvenda=vd.codvenda AND fpvtroco.CODPDV=:CODPDV and fpvtroco.codmovpdv=:CODMOVPDV) and fpvtroco.tipo=3)>0
        )
    ) and
    fpva.codmovpdv=:CODMOVPDV AND FPVA.CODPDV=:CODPDV AND fpva.tipo=3 INTO :VALORTROCO;

/*  SUSPEND; calcula total em troco */




    
/* CALCULA TOTAL DE ENTRADAS  */
/* SISTEMA SISTEMA SISTEMA SISTEMA SISTEMA  */
/* SISTEMA SISTEMA SISTEMA SISTEMA SISTEMA  */
/* SISTEMA SISTEMA SISTEMA SISTEMA SISTEMA  */
FOR SELECT
FPG.FORMA,
FPG.CODFMPAG
FROM FORMASPAGAM FPG WHERE
(FPG.CODFMPAG <> coalesce(:codTroca,0)) and
(FPG.CODFMPAG <> coalesce(:VARIDPAGAMENTOCONTAS,0))
 order by FPG.CODFMPAG
INTO
:FORMAPAGAMENTO,
:COD_FORMA_PAGAMENTO
DO
BEGIN
    idfinalizadora=:COD_FORMA_PAGAMENTO;

    /* Retorna o Total Recebido de cada finalizadora*/
    RECEBIDO=0;

    SELECT
    COALESCE(SUM(FPG.valorPAGO),0) VALORTOTAL,
    COALESCE(SUM(FPG.VALOR),0) VALOR
    FROM pagamentosmovimento(:codmovpdv,  :COD_FORMA_PAGAMENTO) FPG
    INTO
    :varValorTotal,
    :RECEBIDO;


    IF (UPPER(:FORMAPAGAMENTO)='DINHEIRO') then
    begin
         TOTAL=:varValorTotal-COALESCE(:VALORTROCO,0);
         TOTAL=RECEBIDO;

    end else
    begin
            TOTAL=:varValorTotal;
    end

    IF ((UPPER(:FORMAPAGAMENTO)='PROMISSORIA') or
    (UPPER(:FORMAPAGAMENTO)='TROCA') or
    (UPPER(:FORMAPAGAMENTO)='CHEQUEPRE') or
    (UPPER(:FORMAPAGAMENTO)='CHEQUE PRE') or
    (UPPER(:FORMAPAGAMENTO)='CHEQUE-PRE'))
    then
    BEGIN
        ENTRANOCAIXA=0;
    END ELSE
    BEGIN
        ENTRANOCAIXA=1;
    END

    VAR_TOTALENTRADAS=:VAR_TOTALENTRADAS+:RECEBIDO;

    TIPO='ENTRADAS';
    SUSPEND;
END
/* SISTEMA SISTEMA SISTEMA SISTEMA SISTEMA  */



/* CALCULA TOTAL DE SUPRIMENTOS */
VAR_TOTALSUPRIMENTO=0;
RECEBIDO=0;
for SELECT
FP.FORMA,
COALESCE(SUM(FPG.VALORTOTAL),0) TOTAL
FROM FORMASPAGVENDA FPG
inner join venda v on (v.codvenda=fpg.codvenda and v.tiporegistro=7 and v.codmovpdv=:CODMOVPDV)
INNER JOIN FORMASPAGAM FP ON (FP.codfmpag=FPG.codformpag)
WHERE (FPG.CODMOVPDV=:CODMOVPDV AND FPG.TIPO=1) /*and FPG.CODFORMPAG=:codDinheiro*/
GROUP BY 1
INTO
:formapagamento,
:RECEBIDO
do
begin
    VAR_TOTALSUPRIMENTO=VAR_TOTALSUPRIMENTO+:RECEBIDO;
    TOTAL=:RECEBIDO;
    TIPO='SUPRIMENTOS';
    SUSPEND;
end
/* CALCULA TOTAL DE SUPRIMENTOS  */


VAR_TOTALSANGRIA=0;
/* CALCULA TOTAL DE SANGRIAS */
FOR SELECT
FPG.FORMA,
FPG.CODFMPAG
FROM FORMASPAGAM FPG order by 2
INTO
:FORMAPAGAMENTO,
:COD_FORMA_PAGAMENTO
DO
BEGIN

    idfinalizadora=:COD_FORMA_PAGAMENTO;

    /* Retorna o Total Recebido de cada finalizadora */
    RECEBIDO=0;
    SELECT
    COALESCE(SUM(FPG.VALORTOTAL),0) TOTAL
    FROM FORMASPAGVENDA FPG
    inner join venda v on (v.codvenda=fpg.codvenda and v.tiporegistro=8 and v.codmovpdv=:CODMOVPDV)
    WHERE (FPG.CODMOVPDV=:CODMOVPDV and FPG.TIPO=2)
    and FPG.CODFORMPAG=:COD_FORMA_PAGAMENTO
    INTO :RECEBIDO;
    TOTAL=:RECEBIDO;
    VAR_TOTALSANGRIA=:VAR_TOTALSANGRIA+:RECEBIDO;
    /* Total Recebido de cada finalizadora */
    TIPO='SANGRIAS';


    IF (UPPER(:FORMAPAGAMENTO)='DINHEIRO') then
    begin
         varTOTALSANGRIADinheiro=:RECEBIDO;
    end

    SUSPEND;
END
/* CALCULA TOTAL DE SANGRIAS */



   /* SALDO DINHEIRO */
   FORMAPAGAMENTO='SALDO EM DINHEIRO';
   COD_FORMA_PAGAMENTO=:codDinheiro;
   idfinalizadora=:COD_FORMA_PAGAMENTO;

   TOTAL=:varFinDinheiro/*-:VAR_TOTALTROCO*/;
   TOTAL=:TOTAL - :varTOTALSANGRIADinheiro;

   varSaldoDinheiro=:TOTAL ;
   RECEBIDO=:TOTAL;
   TIPO='SALDO EM DINHEIRO';
   SUSPEND;
   /* SALDO DINHEIRO */

end^

SET TERM ; ^

/* Following GRANT statements are generated automatically */

GRANT SELECT ON CONFSISTEMA TO PROCEDURE FECHAMENTO_PERIODO;
GRANT SELECT ON FORMASPAGAM TO PROCEDURE FECHAMENTO_PERIODO;
GRANT SELECT ON MOVPDV TO PROCEDURE FECHAMENTO_PERIODO;
GRANT SELECT ON VENDA TO PROCEDURE FECHAMENTO_PERIODO;
GRANT SELECT ON PRODVENDA TO PROCEDURE FECHAMENTO_PERIODO;
GRANT SELECT ON FORMASPAGVENDA TO PROCEDURE FECHAMENTO_PERIODO;
GRANT SELECT ON USUARIOS TO PROCEDURE FECHAMENTO_PERIODO;
GRANT EXECUTE ON PROCEDURE PAGAMENTOSMOVIMENTO TO PROCEDURE FECHAMENTO_PERIODO;

/* Existing privileges on this procedure */

GRANT EXECUTE ON PROCEDURE FECHAMENTO_PERIODO TO SYSDBA;



































