






SET TERM ^ ;

create or alter procedure FECHAMENTO_PERIODO (
    CODMOVPDV integer)
returns (
    IDFINALIZADORA integer,
    FORMAPAGAMENTO varchar(50),
    TIPO varchar(20),
    VALOR numeric(15,2),
    ABERTURA_DTHR timestamp,
    ABERTURA_OPERADOR integer,
    NOMEOPERADOR varchar(50),
    FECHA_DTH timestamp,
    VENDABRUTA numeric(15,2),
    VARTOTALTROCA numeric(15,2),
    ACRESCIMOS_QUANT_CUPONS integer,
    ACRESCIMOS_VALOR_CUPONS numeric(15,2),
    ACRESCIMOS_QUANT_ITENS integer,
    ACRESCIMOS_VALOR_ITENS numeric(15,2),
    ACRESCIMOS_VALOR_TOTAL numeric(15,2),
    ACRESCIMOS_QUANT_TOTAL integer,
    CANCELAMENTOS_QUANT_CUPONS integer,
    CANCELAMENTOS_VALOR_CUPONS numeric(15,2),
    CANCELAMENTOS_QUANT_ITENS integer,
    CANCELAMENTOS_VALOR_ITENS numeric(15,2),
    CANCELAMENTOS_VALOR_TOTAL numeric(15,2),
    CANCELAMENTOS_QUANT_TOTAL integer,
    VENDA_LIQUIDA numeric(15,2),
    DESCONTOS_QUANT_CUPONS integer,
    DESCONTOS_VALOR_CUPONS numeric(15,2),
    DESCONTOS_QUANT_ITENS integer,
    DESCONTOS_VALOR_ITENS numeric(15,2),
    DESCONTOS_QUANT_TOTAL integer,
    DESCONTOS_VALOR_TOTAL numeric(15,2))
as
declare variable IDTROCA integer;
declare variable IDDINHEIRO integer;
declare variable VARIDPAGAMENTOCONTAS integer;
declare variable VAR_TOTALSUPRIMENTO numeric(15,2);
declare variable VARFINDINHEIRO numeric(15,2);
declare variable VAROUTRAS numeric(15,2);
declare variable VAR_TOTALENTRADAS numeric(15,2);
declare variable RECEBIDO numeric(15,2);
declare variable VAR_TOTALSANGRIA numeric(15,2);
declare variable VARTOTALSANGRIADINHEIRO numeric(15,2);
declare variable VALORABERTURA numeric(15,2);
declare variable VCALCULAVENDABRUTA numeric(15,2);
declare variable VALORTROCO numeric(15,2);
declare variable SANDRIADADA numeric(15,2);
declare variable NAOFAZSANGRIA integer;
BEGIN


VALORTROCO=0;

select
sum(fpva.valor)
from formaspagvenda fpva
where fpva.codvenda in
    (
        select
        fpv.codvenda from formaspagvenda fpv
        inner join formaspagam fp on (fp.codfmpag=fpv.codformpag and FP.forma <> 'DINHEIRO' and fpv.codmovpdv=:CODMOVPDV)
        INNER JOIN VENDA VD ON (fpv.codvenda=vd.codvenda and vd.tiporegistro=1)
        where fpv.codmovpdv=:CODMOVPDV and
        (
          (select count(1) from formaspagvenda fpvtroco where (fpvtroco.codvenda=vd.codvenda AND fpvtroco.codmovpdv=:CODMOVPDV) and fpvtroco.tipo=3)>0
        )
    ) and
    fpva.codmovpdv=:CODMOVPDV AND fpva.tipo=3 INTO :VALORTROCO;

/* Tratamento de Descontos  */
   DESCONTOS_QUANT_TOTAL=0;

   /* Total de Cupons Descontos */
   SELECT Count(*) FROM VENDA V WHERE V.CODMOVPDV=:codmovpdv AND (V.TIPOREGISTRO=1) AND (V.DESCONTO_VAL > 0) into :DESCONTOS_QUANT_CUPONS;

   /* Valor de Cupons Descontos */
   SELECT COALESCE(SUM(V.DESCONTO_VAL),0) FROM VENDA V WHERE (V.CODMOVPDV=:codmovpdv) AND (V.TIPOREGISTRO=1) INTO :DESCONTOS_VALOR_CUPONS;

   /* Total de Itens Descontos */
   SELECT Count(*) FROM PRODVENDA PROD WHERE PROD.CODMOVPDV=:codmovpdv AND PROD.DESCONTOVALOR>0 INTO :DESCONTOS_QUANT_ITENS;

   /* Valor de Itens Descontos */
   SELECT COALESCE(SUM(PROD.DESCONTOVALOR),0) FROM PRODVENDA PROD
   inner join VENDA V ON (V.CODVENDA=PROD.CODVENDA AND V.TIPOREGISTRO=1)
   WHERE PROD.CODMOVPDV=:codmovpdv
   AND COALESCE(PROD.CANCELADO,0)=0
   AND PROD.DESCONTOVALOR>0
   INTO :DESCONTOS_VALOR_ITENS;

DESCONTOS_QUANT_TOTAL=:DESCONTOS_QUANT_CUPONS+:DESCONTOS_QUANT_ITENS;
DESCONTOS_VALOR_TOTAL=:DESCONTOS_VALOR_CUPONS+:DESCONTOS_VALOR_ITENS;
/* Final Tratamento de Descontos */



/* Pega o total de troca             */
SELECT
COALESCE(SUM(FPG.VALORTOTAL),0) TOTAL
FROM FORMASPAGVENDA FPG
INNER JOIN VENDA V ON (V.CODVENDA=FPG.codvenda AND V.tiporegistro=1)
where
(FPG.CODMOVPDV=:codmovpdv)
and FPG.CODFORMPAG=(select FIRST 1 CODFMPAG FROM FORMASPAGAM WHERE UPPER(FORMA)='TROCA')
INTO :VARTOTALTROCA;


/* INICIO DO CALCULO DA VENDA BRUTA */

VENDABRUTA=0;

/* TOTAL DA VENDA */
select
sum(vd.valortotal)
from venda vd
WHERE vd.CODMOVPDV=:CODMOVPDV
and vd.tiporegistro=1
INTO :VENDABRUTA;

/* TOTAL DE CANCELAMENTOS DE VENDAS */
select
COALESCE(sum(vd.valortotal),0)
from venda vd
WHERE vd.CODMOVPDV=:codmovpdv
and vd.tiporegistro=4 into :VCALCULAVENDABRUTA;

VENDABRUTA=:VENDABRUTA+:VCALCULAVENDABRUTA;


/* TOTAL DE CANCELAMENTOS DE ITENS */
select
COALESCE(sum(PV.total),0)
from PRODVENDA PV
INNER JOIN VENDA V ON (V.codvenda=PV.codvenda AND V.codmovpdv=PV.codmovpdv AND V.codpdv=PV.codpdv AND V.tiporegistro=1)
WHERE
PV.CODMOVPDV=:codmovpdv
and PV.tiporegistro=4  into :VCALCULAVENDABRUTA;

VENDABRUTA=:VENDABRUTA+:VCALCULAVENDABRUTA;


/* TOTAL DE DESCONTO DE ITENS */
select
COALESCE(sum(PV.descontovalor),0)
from PRODVENDA PV
INNER JOIN VENDA V ON (V.codvenda=PV.codvenda AND V.codmovpdv=PV.codmovpdv AND V.codpdv=PV.codpdv AND V.tiporegistro=1)
WHERE
PV.CODMOVPDV=:codmovpdv
and PV.tiporegistro=1 into :VCALCULAVENDABRUTA;

VENDABRUTA=:VENDABRUTA+:VCALCULAVENDABRUTA;


/* TOTAL DE DESCONTO DE vendas */
select
COALESCE(sum(v.desconto_val),0)
from VENDA V
WHERE
V.CODMOVPDV=:codmovpdv AND
V.tiporegistro=1 and
v.desconto_val>0 into :VCALCULAVENDABRUTA;

VENDABRUTA=:VENDABRUTA+:VCALCULAVENDABRUTA;
/* Final total venda bruta */

vendabruta = :vendabruta -  :VARTOTALTROCA;

/* Tratamento de acrescimos  */

   /* Quantidade de Cupons acrescimos */
   SELECT Count(*) FROM VENDA V WHERE
   V.CODMOVPDV=:codmovpdv
   AND V.TIPOREGISTRO=1
   AND (ACRESCIMO_VAL > 0)
   into :ACRESCIMOS_QUANT_CUPONS;

   /* Valor de Cupons acrescios */
   SELECT COALESCE(Sum(ACRESCIMO_VAL),0) FROM VENDA V WHERE
   V.CODMOVPDV=:codmovpdv
   AND V.TIPOREGISTRO=1
   AND ACRESCIMO_VAL > 0
   INTO :ACRESCIMOS_VALOR_CUPONS;

   /* Quantidade de Itens ACRESCIMOS */
   SELECT Count(*) FROM PRODVENDA PROD WHERE
   PROD.CODMOVPDV=:codmovpdv
   AND PROD.CANCELADO<>1
   AND PROD.ACRESCIMOVALOR>0
   INTO :ACRESCIMOS_QUANT_ITENS;

   /* Valor de Itens ACRESCIMOS */
   SELECT COALESCE(SUM(PROD.ACRESCIMOVALOR),0) FROM PRODVENDA PROD
   JOIN VENDA V ON
   (V.CODVENDA=PROD.CODVENDA
   AND V.CODMOVPDV=:codmovpdv
   AND V.TIPOREGISTRO=1
   and PROD.CANCELADO<>1)
   WHERE
   V.CODMOVPDV=:codmovpdv
   INTO :ACRESCIMOS_VALOR_ITENS;

   ACRESCIMOS_QUANT_TOTAL=:ACRESCIMOS_QUANT_CUPONS+:ACRESCIMOS_QUANT_ITENS;
   ACRESCIMOS_VALOR_TOTAL=:ACRESCIMOS_VALOR_CUPONS+:ACRESCIMOS_VALOR_ITENS;

/* Final Tratamento de ACRESCIMOS */





/* Tratamento de cancelamentos  */


   /* Quantidade de Cupons Cancelados */
   SELECT Count(*) FROM VENDA V WHERE
   V.CODMOVPDV=:codmovpdv
   AND V.TIPOREGISTRO=4 into :CANCELAMENTOS_QUANT_CUPONS;


   /* Valor de Cupons Cancelados */
   SELECT COALESCE(SUM(V.VALORTOTAL),0)
   FROM VENDA V
   WHERE  V.CODMOVPDV=:codmovpdv
   AND
   V.TIPOREGISTRO=4 INTO :CANCELAMENTOS_VALOR_CUPONS;


   /* Quantidade de Itens Cancelados */
   SELECT Count(*) FROM PRODVENDA PROD
   inner join venda v on(prod.codvenda=v.codvenda)
   WHERE
   PROD.CODMOVPDV=:codmovpdv
   AND PROD.CANCELADO=1
   and v.tiporegistro<>4
   into :CANCELAMENTOS_QUANT_ITENS;

   /* Valor de Itens Cancelados */
   SELECT COALESCE(SUM(PROD.TOTAL),0)+
   COALESCE(SUM(PROD.descontovalor),0)
   FROM PRODVENDA PROD
   inner join venda v on(prod.codvenda=v.codvenda)
   where PROD.CANCELADO=1 AND
   PROD.CODMOVPDV=:codmovpdv
   and v.tiporegistro<>4
   INTO :CANCELAMENTOS_VALOR_ITENS;
   
   CANCELAMENTOS_VALOR_TOTAL=:CANCELAMENTOS_VALOR_CUPONS+:CANCELAMENTOS_VALOR_ITENS;
   CANCELAMENTOS_QUANT_TOTAL=:CANCELAMENTOS_QUANT_CUPONS+:CANCELAMENTOS_QUANT_ITENS;


/* Final Tratamento de cancelamentos */


VENDA_LIQUIDA=:VENDABRUTA  - :CANCELAMENTOS_VALOR_TOTAL + :CANCELAMENTOS_VALOR_ITENS;
VENDA_LIQUIDA=:VENDA_LIQUIDA - :DESCONTOS_VALOR_TOTAL ;








select FIRST 1 CODFMPAG FROM FORMASPAGAM WHERE UPPER(FORMA)='DINHEIRO' into :IDDINHEIRO;
select FIRST 1 coalesce(CODFMPAG,0) FROM FORMASPAGAM WHERE UPPER(FORMA)='TROCA' into :IDTROCA;
select FIRST 1 coalesce(CODFMPAG,0) FROM FORMASPAGAM WHERE UPPER(FORMA)='RECEBIMENTO DE CONTA' into :VARIDPAGAMENTOCONTAS;

select
ABERTURA_DTHR,
ABERTURA_OPERADOR,
(SELECT NOME FROM USUARIOS US WHERE US.codusuario=:ABERTURA_OPERADOR),
FECHA_DTH
from movpdv where codmov=:codmovpdv
into
:ABERTURA_DTHR,
:ABERTURA_OPERADOR,
:NOMEOPERADOR,
:FECHA_DTH;


TIPO='ABERTURA';
FORMAPAGAMENTO='DINHEIRO';
IDFINALIZADORA=IDDINHEIRO;


SELECT
M.ABERTURA_SUPRIMENTO
FROM MOVPDV M WHERE M.CODMOV=:CODMOVPDV INTO :VALOR;

VALORABERTURA=:VALOR;

suspend;



/* pega o total em suprimentos */
SELECT
COALESCE(SUM(FPG.VALORTOTAL),0) TOTAL
FROM FORMASPAGVENDA FPG
where
(FPG.CODMOVPDV=:CODMOVPDV
and FPG.TIPO=1)
and FPG.CODFORMPAG=:iddinheiro into :VAR_TOTALSUPRIMENTO;
/* pega o total em suprimentos */


/* CALCULA TOTAL DE ENTRADAS  */
FOR SELECT
FPG.FORMA,
FPG.CODFMPAG
FROM FORMASPAGAM FPG WHERE
(FPG.CODFMPAG <> coalesce(:IDTROCA,0)) and
(FPG.CODFMPAG <> coalesce(:VARIDPAGAMENTOCONTAS,0))
 order by FPG.CODFMPAG
INTO
:FORMAPAGAMENTO,
:IDFINALIZADORA
DO
BEGIN
    /* Retorna o Total Recebido de cada finalizadora*/
    RECEBIDO=0;

    SELECT
    COALESCE(SUM(FPG.valorPAGO),0) VALORTOTAL,
    COALESCE(SUM(FPG.VALOR),0) VALOR
    FROM pagamentosmovimento(:codmovpdv,  :idfinalizadora) FPG
    INTO
    :VALOR,
    :RECEBIDO;
    
    IF (UPPER(:FORMAPAGAMENTO)='DINHEIRO') then
    begin
         RECEBIDO=:RECEBIDO -coalesce(:VALORTROCO,0);
         VALOR=RECEBIDO;
    end else
    begin
         VALOR=:VALOR;
    end

    VAR_TOTALENTRADAS=:VAR_TOTALENTRADAS+:RECEBIDO;

    TIPO='SISTEMA';
    SUSPEND;
END
/* CALCULA TOTAL DE ENTRADAS  */



/* CALCULA TOTAL DE SANGRIAS */
FOR SELECT
FPG.FORMA,
FPG.CODFMPAG,
FPG.NAOFAZSANGRIA
FROM FORMASPAGAM FPG order by FPG.CODFMPAG
INTO
:FORMAPAGAMENTO,
:IDFINALIZADORA,
:NAOFAZSANGRIA
DO
BEGIN

    TIPO='SANGRIAS';

    if (NAOFAZSANGRIA=1) then
    begin
        /* Retorna o Total Recebido de cada finalizadora */
        RECEBIDO=0;
        SELECT
        COALESCE(SUM(FPG.VALORTOTAL),0) TOTAL
        FROM FORMASPAGVENDA FPG
        inner join venda v on (v.codvenda=fpg.codvenda and v.tiporegistro=1 and v.codmovpdv=:CODMOVPDV)
        WHERE (FPG.CODMOVPDV=:CODMOVPDV AND FPG.TIPO=0)
        and FPG.CODFORMPAG=:IDFINALIZADORA
        INTO :RECEBIDO;
        VALOR=:RECEBIDO;
        VAR_TOTALSANGRIA=:VAR_TOTALSANGRIA+:RECEBIDO;
        /* Total Recebido de cada finalizadora */


    end else
    begin
        /* Retorna o Total Recebido de cada finalizadora */
        RECEBIDO=0;
        SELECT
        COALESCE(SUM(FPG.VALORTOTAL),0) TOTAL
        FROM FORMASPAGVENDA FPG
        inner join venda v on (v.codvenda=fpg.codvenda and v.tiporegistro=8 and v.codmovpdv=:CODMOVPDV)
        WHERE (FPG.CODMOVPDV=:CODMOVPDV AND FPG.TIPO=2)
        and FPG.CODFORMPAG=:IDFINALIZADORA
        INTO :RECEBIDO;
        VALOR=:RECEBIDO;
        VAR_TOTALSANGRIA=:VAR_TOTALSANGRIA+:RECEBIDO;
        /* Total Recebido de cada finalizadora */

        IF (UPPER(:FORMAPAGAMENTO)='DINHEIRO') then
        begin
            varTOTALSANGRIADinheiro=:RECEBIDO;
        end
    end
    
    SUSPEND;
END
/* CALCULA TOTAL DE SANGRIAS */





/* CALCULA TOTAL DE SUPRIMENTOS */
var_TOTALSUPRIMENTO=0;
FOR SELECT
FPG.FORMA,
FPG.CODFMPAG
FROM FORMASPAGAM FPG order by FPG.CODFMPAG
INTO
:FORMAPAGAMENTO,
:IDFINALIZADORA
DO
BEGIN
    /* Retorna o Total Recebido de cada finalizadora */
    RECEBIDO=0;
    SELECT
    COALESCE(SUM(FPG.VALORTOTAL),0) TOTAL
    FROM FORMASPAGVENDA FPG
    inner join venda v on (v.codvenda=fpg.codvenda and v.tiporegistro=7 and v.codmovpdv=:CODMOVPDV)
    WHERE (FPG.CODMOVPDV=:CODMOVPDV and FPG.TIPO=1)
    and FPG.CODFORMPAG=:IDFINALIZADORA
    INTO :RECEBIDO;
    VALOR=:RECEBIDO;
    VAR_TOTALSANGRIA=:VAR_TOTALSANGRIA+:RECEBIDO;
    /* Total Recebido de cada finalizadora */
    TIPO='SUPRIMENTOS';


    IF (UPPER(:FORMAPAGAMENTO)='DINHEIRO') then
    begin
         var_TOTALSUPRIMENTO=:RECEBIDO;
        if (VALORABERTURA>var_TOTALSUPRIMENTO) then
        begin
            VALOR=VALORABERTURA-var_TOTALSUPRIMENTO;
        end ELSE
        begin
            VALOR=var_TOTALSUPRIMENTO-VALORABERTURA;
        end

        SELECT
        COALESCE(SUM(FPG.VALORTOTAL),0) TOTAL
        FROM FORMASPAGVENDA FPG
        inner join venda v on (v.codvenda=fpg.codvenda and v.tiporegistro=8 and v.codmovpdv=:CODMOVPDV)
        WHERE (FPG.CODMOVPDV=:CODMOVPDV and FPG.TIPO=1)
        and FPG.CODFORMPAG=:IDFINALIZADORA into :SANDRIADADA;


        VALOR=:recebido - coalesce(:SANDRIADADA,0);
    end
    
    SUSPEND;

END



/* CALCULA TOTAL DE RECEBIMENTOS */
FOR SELECT
FPG.FORMA,
FPG.CODFMPAG
FROM FORMASPAGAM FPG WHERE
(FPG.CODFMPAG <> coalesce(:IDTROCA,0)) and
(FPG.CODFMPAG <> coalesce(:VARIDPAGAMENTOCONTAS,0))
 order by FPG.CODFMPAG
INTO
:FORMAPAGAMENTO,
:IDFINALIZADORA
DO
BEGIN
    RECEBIDO=0;

    /* Retorna o Total Recebido de cada finalizadora  */
    SELECT
    COALESCE(SUM(FPG.VALORTOTAL),0) TOTAL
    FROM FORMASPAGVENDA FPG
    inner join venda v on (v.codvenda=fpg.codvenda and (v.tiporegistro=17) and v.codmovpdv=:CODMOVPDV)
    WHERE (FPG.CODMOVPDV=:CODMOVPDV and (FPG.TIPO=17) )
    and FPG.CODFORMPAG=:IDFINALIZADORA
    INTO :RECEBIDO;
    VALOR=coalesce(:RECEBIDO,0);

    VAR_TOTALSANGRIA=:VAR_TOTALSANGRIA+:RECEBIDO;
    /* Total Recebido de cada finalizadora */
    TIPO='RECEBIMENTOS';


    IF (UPPER(:FORMAPAGAMENTO)='DINHEIRO') then
    begin
        /* TROCO */
        SELECT
        COALESCE(SUM(FPG.VALOR),0) TOTAL
        FROM FORMASPAGVENDA FPG
        inner join venda v on (v.codvenda=fpg.codvenda and v.tiporegistro=18 and v.codmovpdv=:codmovpdv)
        WHERE (FPG.CODMOVPDV=:codmovpdv and FPG.TIPO=18)
        and FPG.CODFORMPAG=:IDFINALIZADORA into :SANDRIADADA;

         VALOR=:RECEBIDO - COALESCE(:SANDRIADADA,0);
    end

    SUSPEND;
END
/* FIM TOTAL DE RECEBIMENTOS  */

/* CALCULA TROCO DE RECEBIMENTOS */
FOR SELECT
FPG.FORMA,
FPG.CODFMPAG
FROM FORMASPAGAM FPG WHERE
(FPG.CODFMPAG = coalesce(:IDDINHEIRO,0))
order by FPG.CODFMPAG
INTO
:FORMAPAGAMENTO,
:IDFINALIZADORA
DO
BEGIN
    /* Retorna o Total Recebido de cada finalizadora */
    RECEBIDO=0;

    /* pega o total de troco da finalizadora */
    SELECT
    COALESCE(SUM(FPG.VALOR),0) TOTAL
    FROM FORMASPAGVENDA FPG
    inner join venda v on (v.codvenda=fpg.codvenda and v.tiporegistro=18 and v.codmovpdv=:CODMOVPDV)
    WHERE (FPG.CODMOVPDV=:CODMOVPDV and FPG.TIPO=18)
    into :VALOR;

    TIPO='TROCO RECEBIMENTOS';

    SUSPEND;
END
/* FIM TROCO RECEBIMENTOS  */

END^

SET TERM ; ^

/* Following GRANT statements are generated automatically */

GRANT SELECT ON FORMASPAGVENDA TO PROCEDURE FECHAMENTO_PERIODO;
GRANT SELECT ON FORMASPAGAM TO PROCEDURE FECHAMENTO_PERIODO;
GRANT SELECT ON VENDA TO PROCEDURE FECHAMENTO_PERIODO;
GRANT SELECT ON PRODVENDA TO PROCEDURE FECHAMENTO_PERIODO;
GRANT SELECT ON USUARIOS TO PROCEDURE FECHAMENTO_PERIODO;
GRANT SELECT ON MOVPDV TO PROCEDURE FECHAMENTO_PERIODO;
GRANT EXECUTE ON PROCEDURE PAGAMENTOSMOVIMENTO TO PROCEDURE FECHAMENTO_PERIODO;

/* Existing privileges on this procedure */

GRANT EXECUTE ON PROCEDURE FECHAMENTO_PERIODO TO SYSDBA;











